﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class CarsClassConfiguration : ConfigurationElement
{
    public int PriceLowerRange { get; private set; }
    public int PriceUpperRange { get; private set; }
    public float SpeedLowerRange { get; private set; }
    public float SpeedUpperRange { get; private set; }
    public float ReverseSpeedLowerRange { get; private set; }
    public float ReverseSpeedUpperRange { get; private set; }
    public float AccelerationLowerRange { get; private set; }
    public float AccelerationUpperRange { get; private set; }
    public float HandlingLowerRange { get; private set; }
    public float HandlingUpperRange { get; private set; }
    public float DriftingLowerRange { get; private set; }
    public float DriftingUpperRange { get; private set; }

    public CarsClassConfiguration(string id) : base(id)
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            PriceLowerRange = Convert.ToInt32(configElem.Element("PriceLowerRange").Value);
            PriceUpperRange = Convert.ToInt32(configElem.Element("PriceUpperRange").Value);
            SpeedLowerRange = Convert.ToSingle(configElem.Element("SpeedLowerRange").Value);
            SpeedUpperRange = Convert.ToSingle(configElem.Element("SpeedUpperRange").Value);
            ReverseSpeedLowerRange = Convert.ToSingle(configElem.Element("ReverseSpeedLowerRange").Value);
            ReverseSpeedUpperRange = Convert.ToSingle(configElem.Element("ReverseSpeedUpperRange").Value);
            AccelerationLowerRange = Convert.ToSingle(configElem.Element("AccelerationLowerRange").Value);
            AccelerationUpperRange = Convert.ToSingle(configElem.Element("AccelerationUpperRange").Value);
            HandlingLowerRange = Convert.ToSingle(configElem.Element("HandlingLowerRange").Value);
            HandlingUpperRange = Convert.ToSingle(configElem.Element("HandlingUpperRange").Value);
            DriftingLowerRange = Convert.ToSingle(configElem.Element("DriftingLowerRange").Value);
            DriftingUpperRange = Convert.ToSingle(configElem.Element("DriftingUpperRange").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing car class configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}